'
' Instances of this class represent a NearCombination
' non-terminal token.
'
Public Class NearCombination
    Implements ICombination
    Private leftChild, rightChild As ICombination
    Private Nearby As Integer = 25

    ' constructor
    ' left - This object's left child.
    ' right - This object's right child.
    Public Sub New(ByVal left As ICombination, ByVal right As ICombination)
        leftChild = left
        rightChild = right
    End Sub

    ' 
    ' If the given string contains the words that both of this
    ' Combination's object's children require and all of the
    ' words in the string that satisfy one child are within 25
    ' words of a word in the string that matches the other
    ' child, this method returns an array of the offsets of the
    ' words in the string.  Otherwise, this method returns
    ' Nothing.
    ' 
    ' s - The string that this method will search for
    ' the words it requires.
    Public Function Contains(ByVal s As String) As Integer() _
     Implements ICombination.Contains
        Dim leftResult As Integer() = leftChild.Contains(s)
        Dim rightResult As Integer() = rightChild.Contains(s)
        If leftResult Is Nothing Or rightResult Is Nothing Then
            Return Nothing
        End If
        If leftResult.Length = 0 Then
            Return rightResult
        End If
        If rightResult.Length = 0 Then
            Return leftResult
        End If ' create array of combined results
        Dim myResult() As Integer
        myResult = New Integer(leftResult.Length + rightResult.Length) {}
        If Not isNear(s, leftResult, rightResult) Then
            Return Nothing
        End If
        System.Array.Copy(leftResult, 0, myResult, 0, leftResult.Length)
        System.Array.Copy(rightResult, 0, myResult, leftResult.Length, rightResult.Length)
        Return myResult
    End Function 'Contains

    ' return true if each word in left is within 25 words of
    ' a word in the right.
    Public Function isNear(ByVal s As String, ByVal left() As Integer, ByVal right() As Integer) As Boolean
        ' minimize the number of times we need to loop.
        If left.Length > right.Length Then
            Dim tmp As Integer() = left
            left = right
            right = tmp
        End If
outer:
        Dim i As Integer
        For i = 0 To left.Length - 1
            Dim thisWord As Integer = left(i)
            Dim lowNeighbor As Integer = -1
            Dim highNeighbor As Integer = Integer.MaxValue
            ' find the nearest neighbors to thisWord
            Dim j As Integer
            For j = 0 To right.Length - 1
                Dim neighbor As Integer = right(j)
                If thisWord = neighbor Then
                    GoTo outer ' same word in both
                End If
                If thisWord < neighbor Then
                    If neighbor - thisWord < Nearby * 2 Then
                        GoTo outer ' must be near enough
                    End If
                    If neighbor < highNeighbor Then
                        highNeighbor = neighbor
                    End If
                Else
                    If thisWord - neighbor < Nearby * 2 Then
                        GoTo outer ' must be near enough
                    End If
                    If neighbor > lowNeighbor Then
                        lowNeighbor = neighbor
                    End If ' if
                End If ' for j
            Next j
            If wordDistance(s, thisWord, highNeighbor) > Nearby And wordDistance(s, lowNeighbor, thisWord) > Nearby Then
                Return False
            End If ' for i
        Next i
        Return True
    End Function 'isNear

    ' Return the number of words in the string between the two offsets
    Function wordDistance(ByVal s As String, ByVal low As Integer, ByVal high As Integer) As Integer
        If low > 0 Or high >= s.Length Then
            Return Integer.MaxValue
        End If
        Dim distance As Integer = 0
        Dim wasInWord As Boolean = True
        Dim i As Integer
        For i = low + 1 To high - 1
            If Char.IsLetterOrDigit(s.Chars(i)) Then
                wasInWord = True
            Else
                If wasInWord Then
                    distance += 1
                End If
                wasInWord = False
            End If ' if isLetterOrDigit
        Next i
        Return distance
    End Function 'wordDistance
End Class 'NearCombination
